/**
 * Copyright 2008, Southwest Research Institute
 *
 * Methods called to handle the menu component. 
 */
 
 
/**
 * Select the menu that matches the URL when the page loads
 */
if (!document.getElementById) {
    document.getElementById = function() { return null; }
}
var tabMenuIndexes = new Object;
var tabMenuDefaultSubMenu = {
								"Home":"Home",
								"Manage PPS":"Enter / Edit Items",
								"Reports":"Reports",
								"COTS Services":"FDB Search",								
								"Manage Application":"Domain Mapping",
								"User Preferences":"User Preferences",
								"Migration":"Migration DDI"	
							};
function initMenu() {
    var uls = document.getElementsByTagName("ul");
    for (i = 0; i < uls.length; i++) {
        if (uls[i].className == "menuList") {
            decorateMenu(uls[i]);
        }
    }
}

function decorateMenu(menu) {
    var items = menu.getElementsByTagName("li");
    
    for (var i=0; i < items.length; i++) { 
    	if(items[i].children[0].title && items[i].children[0].title != "") {   
			tabMenuIndexes[items[i].children[0].title] = i;
		}
    }
    
    activateMenu(items);
}

function getDefaultTabIndex(menuText) {
	if (tabMenuIndexes[tabMenuDefaultSubMenu[menuText]]) {
		return tabMenuIndexes[tabMenuDefaultSubMenu[menuText]];
	} else if (tabMenuIndexes[menuText]) {
		return tabMenuIndexes[menuText];
	} else {
		return 0;
	}
}

/*
 * Sets the "selected" style on the selected menu.  First looks at the menuSelected hidden field and tries to find
 * the tab by id.  If menuSelected is not set, then it tries to find it by comparing current url with each menu tab's url.
 * If the menu tab is a submenu, it also sets the parent tab to selected. 
 */
function activateMenu(items) {
    var menuSelected = document.getElementById("menuSelected").value;
    
    if (menuSelected != undefined && menuSelected != ""){
    	var selectedMenuElement = document.getElementById(menuSelected);
    	if (selectedMenuElement != undefined){
            if (selectedMenuElement.parentNode.parentNode.className == "submenu") {
            	selectedMenuElement.className="selected";
            	selectedMenuElement.parentNode.parentNode.parentNode.className="selected";
            } else {
            	selectedMenuElement.parentNode.className+="selected";
            }
    	}
    }    
    else {
    	var current = document.location.toString();
	    for (var i=0; i < items.length; i++) {
	        var url = items[i].children[0].href;
	        if (url.indexOf(current) != -1) {
	            if (items[i].parentNode.className == "submenu") {
	                items[i].children[0].className="selected";
	                items[i].parentNode.parentNode.className="selected";
	            } else {
	                items[i].className+="selected";
	            }
	        }
	    }
    }
}